unit Ellipse;
{*******************************************************************************
  ShapesDemo
  Written by David Clegg, davidclegg@optusnet.com.au.

  This unit contains the Ellipse class used to render an ellipse onto a GDI+
  drawing surface.
*******************************************************************************}

interface

uses
  Shape, System.Drawing, System.Drawing.Drawing2D;

type

  /// <summary>
  /// Class to draw an Ellipse.
  /// </summary>
  TEllipse = class(TShape)
  protected
    function GetShape(pStartPoint, pEndPoint: Point): GraphicsPath; override;
  public
    procedure DrawEllipse(pBrush: Brush; pStartPoint, pEndPoint: Point);
    procedure OutlineEllipse(pPen: Pen; pStartPoint, pEndPoint: Point);
  end;

implementation

/// <summary>
/// Return a GraphicsPath representing the bounds of the Ellipse based on
/// pStartPoint and pEndPoint.
/// </summary>
function TEllipse.GetShape(pStartPoint, pEndPoint: Point): GraphicsPath;
begin
  Result := GraphicsPath.Create;
  Result.AddEllipse(DoGetRectangle(pStartPoint, pEndPoint));
end;

/// <summary>
/// Alternative method to draw an Elipse. Not as good as the
/// inherited Draw method as it doesn't cater for if an endPoint X or Y
/// value is less than its corresponding startPoint value.
/// </summary>
procedure TEllipse.DrawEllipse(pBrush: Brush; pStartPoint,pEndPoint: Point);
begin
  Canvas.FillEllipse(pBrush, DoGetRectangle(pStartPoint, pEndPoint));
end;

/// <summary>
/// Alternative method to draw an Elipse outline. Not as good as the
/// inherited Draw method as it doesn't cater for if an endPoint X or Y
/// value is less than its corresponding startPoint value.
/// </summary>
procedure TEllipse.OutlineEllipse(pPen: Pen; pStartPoint, pEndPoint: Point);
begin
  Canvas.DrawEllipse(pPen, DoGetRectangle(pStartPoint, pEndPoint));
end;

end.
